<%@ Page Language="C#" MasterPageFile="~/usrManager.master" AutoEventWireup="true" Inherits="Organizations" Title="Untitled Page" Codebehind="Organizations.aspx.cs" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<asp:Content ID="oContent" ContentPlaceHolderID="oBody" runat="server">
  <script language="javascript" type="text/javascript" src="../Includes/easyAjax.js" enableviewstate="false"></script>
  <script language="javascript" type="text/javascript">
    //<![CDATA[
    var szPlus = "<% = Page.ResolveUrl("~/Images/Plus.gif") %>";
    var szMinus = "<% = Page.ResolveUrl("~/Images/Minus.gif") %>";
    
    // Valido si una Organizacion tiene Unidades Operacionales asignadas que se encuentren acticas
    function validateDependence(pOrgId, msgUoIsAssigned, msgQuestion, msgEntity, msgConfirm)
    {
      var rand;
      var blnIsAssigned;
      var ea = new easyAjax();
      
      rand = Math.random();
      blnIsAssigned = false;

      ea.openText("ValidateIsAssigned.aspx?OrgId=" + pOrgId + "&nocache=" + rand, function(szResult){
        if (szResult.toUpperCase() == 'TRUE')
        {
          blnIsAssigned = true;
        }
      });
      
      if (blnIsAssigned == true) //si la Org SI tiene Uos asignadas
      {
        alert('\'' + pOrgId + '\' ' + msgUoIsAssigned);
        return false;
      }
      else //si la Org NO tiene Uos asignadas
      {
        return ConfirmDelete('ORG', pOrgId, msgQuestion, msgEntity, msgConfirm);
      }
    }
    //]]>
  </script>
  <script language="javascript" type="text/javascript" src="<% = Page.ResolveUrl("~/Includes/CollapsablePanels.js") %>"></script>
  <!-- Logo de Pectra y Seccion Organizaciones -->
  <table border="0" cellpadding="0" cellspacing="0" class="tblTitle">
    <tr>
      <td class="SecTitle">
        <img alt="" class="PectraLogo<% = ((Request.ServerVariables["HTTP_USER_AGENT"].IndexOf("MSIE") > -1) ? "IE": "").ToString() %>" src="<% = Page.ResolveUrl(string.Format("~/Images/PectraLogo.{0}.png", Page.Theme)) %>" />
        <span id="spanOrgs" runat="server">Organizaciones</span>
      </td>
    </tr>
  </table>
  <!-- Panel de Filtro -->
  <asp:Panel ID="pnlFilter" CssClass="Filter" runat="server" Width="100%">
    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
      <tr>
        <td id="tdFilterCaption" class="FilterCaption">
          <a href="javascript:showPanel('tdFilterContent', 'imgFilter', szPlus, szMinus);" class="Filter">
            <img id="imgFilter" alt="Mostrar/Ocultar Filtro" src="<%= Page.ResolveUrl("~/Images/Minus.gif") %>" class="Filter" />
            <span id="spanFilter" runat="server">Filtro </span></a>
        </td>
        <td class="FilterOptions">
          <asp:Button SkinID="Filter" ID="btnAplicarFiltro" runat="server" Text="Aplicar Filtro" OnClick="btnAplicarFiltro_Click" />
          <asp:Button SkinID="Filter" ID="btnAgregar" runat="server" Text="Agregar" OnClick="btnAgregar_Click" />
          <asp:Button SkinID="Filter" ID="btnRefrescar" runat="server" Text="Refrescar" OnClick="btnRefrescar_Click" />
        </td>
      </tr>
      <tr>
        <td id="tdFilterContent" class="FilterContent" colspan="2">
          <table border="0" cellpadding="0" cellspacing="1" style="width: 100%;">
            <tr>
              <td class="Caption">
                &nbsp;<span id="spanOrgId" runat="server">Id de Organizaci&oacute;n</span>:
              </td>
              <td>
                <asp:TextBox ID="txtOrgId" SkinID="Filter" runat="server" MaxLength="50" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption">
                &nbsp;<span id="spanDescription" runat="server">Descripci&oacute;n</span>:
              </td>
              <td>
                <asp:TextBox ID="txtOrgDescription" SkinID="Filter" runat="server" MaxLength="255" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </asp:Panel>
  <hr class="Separator" />
  <!-- Grilla de Organizaciones -->
  <div class="Filter">
    <asp:GridView ID="gridOrg" runat="server" AutoGenerateColumns="False" DataKeyNames="OrgId" SkinID="Filter" AllowPaging="True" AllowSorting="True" DataSourceID="objDataSource" OnRowCreated="gridOrg_RowCreated" PageSize="5" OnDataBound="gridOrg_DataBound">
      <PagerSettings FirstPageImageUrl="~/Images/NavFirstPage.gif" FirstPageText="Primero" LastPageImageUrl="~/Images/NavLastPage.gif" LastPageText="Ultimo" Mode="NumericFirstLast" PageButtonCount="3" />
      <Columns>
        <asp:BoundField ReadOnly="True" DataField="OrgId" SortExpression="OrgId" HeaderText="Id de Organizaci&#243;n">
          <ItemStyle Width="35%" Wrap="False"></ItemStyle>
        </asp:BoundField>
        <asp:BoundField DataField="OrgDescription" SortExpression="OrgDescription" HeaderText="Descripci&#243;n">
          <ItemStyle Width="45%"></ItemStyle>
        </asp:BoundField>
        <asp:TemplateField HeaderText="Acciones">
          <ItemStyle Width="20%" HorizontalAlign="Center"></ItemStyle>
          <ItemTemplate>
            <asp:Button ID="btnEditOrg" runat="server" SkinID="Filter" Style="width: 50px" Text="Edit" OnClick="btnEditOrg_Click" EnableViewState="False" />
            <asp:Button ID="btnDeleteOrg" runat="server" SkinID="Filter" Style="width: 50px" Text="Delete" OnClick="btnDeleteOrg_Click" EnableViewState="False" />
          </ItemTemplate>
        </asp:TemplateField>
      </Columns>
    </asp:GridView>
    <asp:ObjectDataSource ID="objDataSource" runat="server" SelectMethod="OrgGetAll" TypeName="Pectra.OrgInterface.Engine"></asp:ObjectDataSource>
  </div>
  <!-- Informacion de cantidad y pagina -->
  <div class="Filter" id="divPaging" runat="server" visible="true">
    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
      <tr>
        <td id="td2" class="FilterCaption" style="width: 50%; border-right: solid 1px;">
          <b><span id="spanInformation" runat="server">Informaci&oacute;n</span>: </b><span id="spanPageOnetoOne" runat="server">P&aacute;gina 1 de 1</span>&nbsp;|&nbsp;<b><span id="spanCount" runat="server">Cantidad</span>: </b>
          <%=ViewState["RowsCount"]%>
          <span id="spanOrgsPaging" runat="server">organizaciones</span>
        </td>
      </tr>
    </table>
  </div>
  <br />
</asp:Content>
